/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.recipes.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fr.iglee42.evolvedmekanism.recipes.AlloyerRecipe;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class AlloyerRecipeSerializer<RECIPE extends AlloyerRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public AlloyerRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray mainInput = GsonHelper.m_13885_((JsonObject)json, (String)"mainInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"mainInput") : GsonHelper.m_13930_((JsonObject)json, (String)"mainInput");
        ItemStackIngredient mainIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)mainInput);
        JsonArray extraInput = GsonHelper.m_13885_((JsonObject)json, (String)"extraInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"extraInput") : GsonHelper.m_13930_((JsonObject)json, (String)"extraInput");
        ItemStackIngredient extraIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)extraInput);
        JsonArray secondExtraInput = GsonHelper.m_13885_((JsonObject)json, (String)"secondExtraInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"secondExtraInput") : GsonHelper.m_13930_((JsonObject)json, (String)"secondExtraInput");
        ItemStackIngredient secondExtraIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)secondExtraInput);
        ItemStack output = SerializerHelper.getItemStack((JsonObject)json, (String)"output");
        if (output.m_41619_()) {
            throw new JsonSyntaxException("Alloyer recipe output must not be empty.");
        }
        return this.factory.create(recipeId, mainIngredient, extraIngredient, secondExtraIngredient, output);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient mainInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStackIngredient extraInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStackIngredient secondExtraInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStack output = buffer.m_130267_();
            return this.factory.create(recipeId, mainInput, extraInput, secondExtraInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading alloyer recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((AlloyerRecipe)((Object)recipe)).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing alloyer recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends AlloyerRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ItemStackIngredient var3, ItemStackIngredient var4, ItemStack var5);
    }
}

